/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.async.statistics;

public final class TaskStatistics {
    private Long queueStart;
    private Long execStart;
    private Long execEnd;

    public TaskStatistics() {
        this.enqueue();
    }

    public void enqueue() {
        this.queueStart = System.nanoTime();
    }

    public void startExecution() {
        this.execStart = System.nanoTime();
    }

    public void stopExecution() {
        this.execEnd = System.nanoTime();
    }

    public Long getQueueTime() {
        return TaskStatistics.diff(this.queueStart, this.execStart);
    }

    public Long getExecutionTime() {
        return TaskStatistics.diff(this.execStart, this.execEnd);
    }

    public Long getTotalTime() {
        return TaskStatistics.diff(this.queueStart, this.execEnd);
    }

    private static Long diff(Long queueStart, Long execEnd) {
        return execEnd - queueStart;
    }
}

