/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.async.task.listener;

import org.hawaiiframework.async.statistics.TaskStatistics;
import org.hawaiiframework.async.task.listener.TaskListener;
import org.hawaiiframework.async.timeout.SharedTaskContext;
import org.hawaiiframework.logging.model.AutoCloseableKibanaLogField;
import org.hawaiiframework.logging.model.KibanaLogField;
import org.hawaiiframework.logging.model.KibanaLogFieldNames;
import org.hawaiiframework.logging.model.KibanaLogFields;
import org.hawaiiframework.logging.model.KibanaLogTypeNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingTaskListener
implements TaskListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingTaskListener.class);
    private SharedTaskContext sharedTaskContext;

    public int getOrder() {
        return 0;
    }

    @Override
    public void setSharedTaskContext(SharedTaskContext sharedTaskContext) {
        this.sharedTaskContext = sharedTaskContext;
    }

    @Override
    public void startExecution() {
        try (AutoCloseableKibanaLogField callStart = KibanaLogFields.tagCloseable((KibanaLogField)KibanaLogFieldNames.LOG_TYPE, (Enum)KibanaLogTypeNames.CALL_START);){
            LOGGER.info("Performing task '{}' with id '{}'.", (Object)this.sharedTaskContext.getTaskName(), (Object)this.sharedTaskContext.getTaskId());
        }
    }

    @Override
    public void finish() {
        TaskStatistics taskStatistics = this.sharedTaskContext.getTaskStatistics();
        String duration = LoggingTaskListener.formatTime(taskStatistics.getTotalTime().longValue());
        try (AutoCloseableKibanaLogField callEnd = KibanaLogFields.tagCloseable((KibanaLogField)KibanaLogFieldNames.LOG_TYPE, (Enum)KibanaLogTypeNames.CALL_END);
             AutoCloseableKibanaLogField durationField = KibanaLogFields.tagCloseable((KibanaLogField)KibanaLogFieldNames.CALL_DURATION, (String)duration);){
            LOGGER.info("Task '{}' with id '{}' took '{}' msec ('{}' queue time, '{}' execution time).", new Object[]{this.sharedTaskContext.getTaskName(), this.sharedTaskContext.getTaskId(), duration, LoggingTaskListener.formatTime(taskStatistics.getQueueTime().longValue()), LoggingTaskListener.formatTime(taskStatistics.getExecutionTime().longValue())});
        }
    }

    private static String formatTime(double time) {
        return String.format("%.2f", time / 1000000.0);
    }
}

