/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.async.timeout;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.hawaiiframework.async.model.ExecutorConfigurationProperties;
import org.hawaiiframework.async.statistics.ExecutorStatistics;
import org.hawaiiframework.async.statistics.TaskStatistics;
import org.hawaiiframework.async.task.listener.TaskListener;
import org.hawaiiframework.async.timeout.SharedTaskContextHolder;
import org.hawaiiframework.async.timeout.TaskAbortStrategy;
import org.hawaiiframework.async.timeout.TaskRemoveStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.OrderComparator;

public class SharedTaskContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(SharedTaskContext.class);
    private static final OrderComparator ORDER_COMPARATOR = new OrderComparator();
    private TaskRemoveStrategy taskRemoveStrategy;
    private TaskAbortStrategy taskAbortStrategy;
    private TaskRemoveStrategy timeoutGuardTaskRemoveStrategy;
    private final String taskName;
    private final String taskId;
    private final ExecutorConfigurationProperties executorConfigurationProperties;
    private final List<TaskListener> taskListeners;
    private final ExecutorStatistics executorStatistics;
    private boolean aborted;
    private final TaskStatistics taskStatistics;

    public SharedTaskContext(String taskName, ExecutorConfigurationProperties executorConfigurationProperties, ExecutorStatistics executorStatistics, List<TaskListener> taskListeners) {
        this.taskName = taskName;
        this.executorConfigurationProperties = executorConfigurationProperties;
        this.taskListeners = taskListeners;
        this.taskId = UUID.randomUUID().toString();
        this.taskStatistics = new TaskStatistics();
        this.executorStatistics = executorStatistics;
        taskListeners.forEach(context -> context.setSharedTaskContext(this));
    }

    public void setTaskRemoveStrategy(TaskRemoveStrategy taskRemoveStrategy) {
        this.taskRemoveStrategy = taskRemoveStrategy;
    }

    public void setTimeoutGuardTaskRemoveStrategy(TaskRemoveStrategy timeoutGuardTaskRemoveStrategy) {
        this.timeoutGuardTaskRemoveStrategy = timeoutGuardTaskRemoveStrategy;
    }

    public void setTaskAbortStrategy(TaskAbortStrategy taskAbortStrategy) {
        this.taskAbortStrategy = taskAbortStrategy;
    }

    public void abortBusinessTask() {
        if (this.taskAbortStrategy != null) {
            this.taskAbortStrategy.invoke();
            this.executorStatistics.incrementAbortedTaskCount();
            this.aborted = true;
        }
    }

    public Integer getTimeout() {
        return this.executorConfigurationProperties.getTaskTimeout(this.taskName);
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public void timeout() {
        if (this.isNotRemovedFromExecutor()) {
            LOGGER.debug("Aborting task '{}' with id '{}.", (Object)this.getTaskName(), (Object)this.getTaskId());
            this.abortBusinessTask();
        }
        this.taskListeners.stream().sorted(ORDER_COMPARATOR).forEach(TaskListener::timeout);
    }

    private boolean isNotRemovedFromExecutor() {
        if (this.taskRemoveStrategy == null) {
            throw new IllegalStateException("TimeoutGuardTask is executing, but task remove strategy is set.");
        }
        boolean isRemoved = this.taskRemoveStrategy.invoke();
        if (isRemoved) {
            this.executorStatistics.incrementAbortedTaskCount();
            LOGGER.debug("Removed task '{}' from the executors queue.", (Object)this.getTaskId());
        }
        return !isRemoved;
    }

    public void startExecution() {
        this.taskStatistics.startExecution();
        this.taskListeners.stream().sorted(ORDER_COMPARATOR).forEach(listener -> {
            SharedTaskContext.logListener(listener, "startExecution()");
            listener.startExecution();
        });
    }

    public void finish() {
        if (!this.isAborted()) {
            this.timeoutGuardTaskRemoveStrategy.invoke();
        }
        this.taskStatistics.stopExecution();
        this.taskListeners.stream().sorted(Collections.reverseOrder(ORDER_COMPARATOR)).forEach(listener -> {
            SharedTaskContext.logListener(listener, "finish()");
            try {
                listener.finish();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        SharedTaskContextHolder.remove();
    }

    private static void logListener(TaskListener listener, String method) {
        LOGGER.trace("Calling listener '{}#{}'.", (Object)listener.getClass().getSimpleName(), (Object)method);
    }

    public TaskStatistics getTaskStatistics() {
        return this.taskStatistics;
    }
}

