/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.async.timeout;

import org.hawaiiframework.async.timeout.SharedTaskContext;
import org.hawaiiframework.async.timeout.TaskAbortStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SharedTaskContextHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SharedTaskContextHolder.class);
    private static ThreadLocal<SharedTaskContext> threadLocalStore = new ThreadLocal();

    private SharedTaskContextHolder() {
    }

    public static void register(SharedTaskContext sharedTaskContext) {
        threadLocalStore.set(sharedTaskContext);
    }

    public static void remove() {
        threadLocalStore.remove();
    }

    public static void setTaskAbortStrategy(TaskAbortStrategy taskAbortStrategy) {
        SharedTaskContext sharedTaskContext = SharedTaskContextHolder.get();
        if (sharedTaskContext != null) {
            LOGGER.trace("Setting task abort strategy.");
            sharedTaskContext.setTaskAbortStrategy(taskAbortStrategy);
        }
    }

    public static SharedTaskContext get() {
        return threadLocalStore.get();
    }

    public static String getTaskId() {
        SharedTaskContext sharedTaskContext = SharedTaskContextHolder.get();
        if (sharedTaskContext == null) {
            return null;
        }
        return sharedTaskContext.getTaskId();
    }
}

