/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.async.timeout;

import java.util.concurrent.ThreadPoolExecutor;
import org.hawaiiframework.async.timeout.TaskAbortStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskRemoveStrategy
implements TaskAbortStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskRemoveStrategy.class);
    private final ThreadPoolExecutor executor;
    private final Runnable task;
    private final String taskType;
    private final String taskId;

    public TaskRemoveStrategy(ThreadPoolExecutor executor, Runnable task, String taskType, String taskId) {
        this.executor = executor;
        this.task = task;
        this.taskType = taskType;
        this.taskId = taskId;
    }

    @Override
    public boolean invoke() {
        LOGGER.trace("Removing {} task with id '{}'.", (Object)this.taskType, (Object)this.taskId);
        boolean wasRemoved = this.executor.remove(this.task);
        LOGGER.trace("Removal was {}successful.", (Object)(wasRemoved ? "" : "not "));
        return wasRemoved;
    }
}

