/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.boot.autoconfigure.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.validation.ValidationException;
import java.util.List;
import org.hawaiiframework.converter.ModelConverter;
import org.hawaiiframework.validation.ValidationError;
import org.hawaiiframework.web.exception.ApiErrorResponseEnricher;
import org.hawaiiframework.web.exception.DefaultExceptionResponseFactory;
import org.hawaiiframework.web.exception.ErrorResponseEnricher;
import org.hawaiiframework.web.exception.ErrorResponseEntityBuilder;
import org.hawaiiframework.web.exception.ErrorResponseStatusEnricher;
import org.hawaiiframework.web.exception.ExceptionResponseFactory;
import org.hawaiiframework.web.exception.HawaiiResponseEntityExceptionHandler;
import org.hawaiiframework.web.exception.HawaiiSpringResponseEntityExceptionHandler;
import org.hawaiiframework.web.exception.JakartaValidationsEntityExceptionHandler;
import org.hawaiiframework.web.exception.MethodArgumentNotValidResponseEnricher;
import org.hawaiiframework.web.exception.RequestInfoErrorResponseEnricher;
import org.hawaiiframework.web.exception.ValidationErrorResponseEnricher;
import org.hawaiiframework.web.resource.ObjectErrorResourceAssembler;
import org.hawaiiframework.web.resource.ValidationErrorResource;
import org.hawaiiframework.web.resource.ValidationErrorResourceAssembler;
import org.hawaiiframework.web.util.HostResolver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.validation.ObjectError;

@Configuration
@ConditionalOnWebApplication
public class HawaiiRestAutoConfiguration {
    @Autowired
    private ObjectMapper objectMapper;

    @Bean
    public HostResolver hostResolver() {
        return new HostResolver();
    }

    @Bean
    public ObjectErrorResourceAssembler objectErrorResourceAssembler() {
        return new ObjectErrorResourceAssembler(this.objectMapper);
    }

    @Bean
    public ExceptionResponseFactory exceptionResponseFactory() {
        return new DefaultExceptionResponseFactory();
    }

    @Bean
    public ErrorResponseEntityBuilder errorResponseEntityBuilder(List<ErrorResponseEnricher> errorResponseEnrichers) {
        return new ErrorResponseEntityBuilder(this.exceptionResponseFactory(), errorResponseEnrichers);
    }

    @Bean
    public HawaiiResponseEntityExceptionHandler hawaiiResponseEntityExceptionHandler(ErrorResponseEntityBuilder errorResponseEntityBuilder) {
        return new HawaiiResponseEntityExceptionHandler(errorResponseEntityBuilder);
    }

    @Bean
    @ConditionalOnClass(value={AccessDeniedException.class})
    public HawaiiSpringResponseEntityExceptionHandler springSecurityResponseEntityExceptionHandler(ErrorResponseEntityBuilder errorResponseEntityBuilder) {
        return new HawaiiSpringResponseEntityExceptionHandler(errorResponseEntityBuilder);
    }

    @Bean
    @ConditionalOnClass(value={ValidationException.class})
    public JakartaValidationsEntityExceptionHandler jakartaValidationsEntityExceptionHandler(ErrorResponseEntityBuilder errorResponseEntityBuilder) {
        return new JakartaValidationsEntityExceptionHandler(errorResponseEntityBuilder);
    }

    @Bean
    public ErrorResponseStatusEnricher errorResponseStatusEnricher() {
        return new ErrorResponseStatusEnricher();
    }

    @Bean
    public RequestInfoErrorResponseEnricher requestInfoErrorResponseEnricher() {
        return new RequestInfoErrorResponseEnricher();
    }

    @Bean
    public MethodArgumentNotValidResponseEnricher methodArgumentNotValidResponseEnricher(ModelConverter<ObjectError, ValidationErrorResource> objectErrorResourceAssembler) {
        return new MethodArgumentNotValidResponseEnricher(objectErrorResourceAssembler);
    }

    @Bean
    public ValidationErrorResourceAssembler validationErrorResourceAssembler() {
        return new ValidationErrorResourceAssembler(this.objectMapper);
    }

    @Bean
    public ValidationErrorResponseEnricher validationErrorResponseEnricher(ModelConverter<ValidationError, ValidationErrorResource> validationErrorResourceAssembler) {
        return new ValidationErrorResponseEnricher(validationErrorResourceAssembler);
    }

    @Bean
    public ApiErrorResponseEnricher apiErrorResponseEnricher() {
        return new ApiErrorResponseEnricher();
    }
}

