/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging;

import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.hawaiiframework.logging.model.KibanaLogField;
import org.hawaiiframework.logging.model.KibanaLogFieldNames;
import org.hawaiiframework.logging.model.KibanaLogFields;

public class KibanaLogTransaction
implements AutoCloseable {
    private final boolean hasTx;

    public KibanaLogTransaction(String transactionType) {
        String txId = KibanaLogFields.get(KibanaLogFieldNames.TX_ID);
        this.hasTx = StringUtils.isNotBlank((CharSequence)txId);
        if (!this.hasTx) {
            KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.TX_ID, KibanaLogTransaction.createTxId());
        }
        KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.TX_TYPE, transactionType);
    }

    @Override
    public void close() {
        if (!this.hasTx) {
            KibanaLogFields.clear();
        }
    }

    private static String createTxId() {
        return KibanaLogTransaction.createTxId(UUID.randomUUID());
    }

    private static String createTxId(UUID uuid) {
        return uuid.toString();
    }
}

