/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.config;

import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.ext.logging.LoggingInInterceptor;
import org.apache.cxf.ext.logging.LoggingOutInterceptor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnClass(name={"org.apache.cxf.Bus"})
@ConditionalOnProperty(prefix="hawaii.logging.soap", name={"enabled"}, matchIfMissing=true)
@Configuration
public class CxfLoggingConfiguration {
    @Bean
    public Bus busConfiguration() {
        Bus bus = BusFactory.getDefaultBus();
        bus.getInInterceptors().add(CxfLoggingConfiguration.loggingInInterceptor());
        bus.getInFaultInterceptors().add(CxfLoggingConfiguration.loggingInInterceptor());
        bus.getOutInterceptors().add(CxfLoggingConfiguration.loggingOutInterceptor());
        bus.getOutFaultInterceptors().add(CxfLoggingConfiguration.loggingOutInterceptor());
        return bus;
    }

    private static LoggingInInterceptor loggingInInterceptor() {
        LoggingInInterceptor inInterceptor = new LoggingInInterceptor();
        inInterceptor.setPrettyLogging(true);
        return inInterceptor;
    }

    private static LoggingOutInterceptor loggingOutInterceptor() {
        LoggingOutInterceptor outInterceptor = new LoggingOutInterceptor();
        outInterceptor.setPrettyLogging(true);
        return outInterceptor;
    }
}

