/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.config;

import jakarta.servlet.http.HttpServletRequest;
import org.hawaiiframework.logging.config.MediaTypeVoter;
import org.hawaiiframework.logging.config.RequestVoter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterVoter {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterVoter.class);
    private final MediaTypeVoter mediaTypeVoter;
    private final RequestVoter requestVoter;

    public FilterVoter(MediaTypeVoter mediaTypeVoter, RequestVoter requestVoter) {
        this.mediaTypeVoter = mediaTypeVoter;
        this.requestVoter = requestVoter;
    }

    public boolean enabled(HttpServletRequest request) {
        Boolean isEnabled = (Boolean)request.getAttribute(this.getAttributeName());
        LOGGER.trace("Got '{}' from attribute.", (Object)isEnabled);
        if (isEnabled == null) {
            boolean mediaTypeAllowed = this.mediaTypeVoter.mediaTypeMatches(request.getContentType());
            boolean requestAllowed = this.requestVoter.allowed(request);
            isEnabled = mediaTypeAllowed && requestAllowed;
            request.setAttribute(this.getAttributeName(), (Object)isEnabled);
        }
        LOGGER.trace("Is enabled: '{}'.", (Object)isEnabled);
        return isEnabled;
    }

    private String getAttributeName() {
        return this.getClass().getPackageName() + ".FILTER_VOTER";
    }
}

