/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.config;

import graphql.GraphQL;
import java.util.List;
import org.hawaiiframework.logging.web.filter.DataFetchExceptionBeanPostProcessor;
import org.hawaiiframework.logging.web.util.DefaultGraphQlErrorTypeHttpStatusSupplier;
import org.hawaiiframework.logging.web.util.GraphQlErrorTypeHttpStatusSupplier;
import org.hawaiiframework.logging.web.util.GraphQlHttpStatusSupplier;
import org.hawaiiframework.logging.web.util.GraphQlTransactionTypeSupplier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.graphql.execution.GraphQlSource;

@Configuration
@ConditionalOnClass(value={GraphQL.class, GraphQlSource.class})
@ConditionalOnProperty(prefix="hawaii.logging.filters.transaction-type", name={"enabled"}, matchIfMissing=true)
public class GraphqlConfiguration {
    public static final String CONFIG_PREFIX = "hawaii.logging.graphql";

    @Bean
    @ConditionalOnProperty(prefix="hawaii.logging.graphql", name={"enabled"}, matchIfMissing=true)
    public DataFetchExceptionBeanPostProcessor dataFetchExceptionBeanPostProcessor(List<GraphQlHttpStatusSupplier> suppliers) {
        return new DataFetchExceptionBeanPostProcessor(suppliers);
    }

    @Bean
    @ConditionalOnProperty(prefix="hawaii.logging.graphql", name={"enabled"}, matchIfMissing=true)
    public GraphQlTransactionTypeSupplier graphQlTransactionTypeSupplier() {
        return new GraphQlTransactionTypeSupplier();
    }

    @Bean
    @ConditionalOnProperty(prefix="hawaii.logging.graphql", name={"enabled"}, matchIfMissing=true)
    public DefaultGraphQlErrorTypeHttpStatusSupplier defaultGraphQlErrorTypeHttpStatusSupplier() {
        return new DefaultGraphQlErrorTypeHttpStatusSupplier();
    }

    @Bean
    @ConditionalOnProperty(prefix="hawaii.logging.graphql", name={"enabled"}, matchIfMissing=true)
    public GraphQlErrorTypeHttpStatusSupplier graphQlErrorTypeHttpStatusSupplier() {
        return new GraphQlErrorTypeHttpStatusSupplier();
    }
}

