/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.config.filter;

import org.hawaiiframework.logging.config.filter.FilterRegistrationBeanUtil;
import org.hawaiiframework.logging.web.filter.BusinessTransactionIdFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="hawaii.logging.filters.business-transaction-id", name={"enabled"}, matchIfMissing=false)
public class BusinessTransactionIdFilterConfiguration {
    public static final String CONFIG_PREFIX = "hawaii.logging.filters.business-transaction-id";
    private static final Logger LOGGER = LoggerFactory.getLogger(BusinessTransactionIdFilterConfiguration.class);
    @Value(value="${hawaii.logging.filters.business-transaction-id.http-header:X-Hawaii-Business-Tx-Id}")
    private String headerName;
    @Value(value="${hawaii.logging.filters.business-transaction-id.order:-600}")
    private int filterOrder;

    @Bean
    @ConditionalOnProperty(prefix="hawaii.logging.filters.business-transaction-id", name={"enabled"}, matchIfMissing=true)
    public BusinessTransactionIdFilter businessTransactionIdFilter() {
        LOGGER.trace("Configuration: header '{}', order '{}'.", (Object)this.headerName, (Object)this.filterOrder);
        return new BusinessTransactionIdFilter(this.headerName);
    }

    @Bean
    @ConditionalOnProperty(prefix="hawaii.logging.filters.business-transaction-id", name={"enabled"}, matchIfMissing=true)
    public FilterRegistrationBean<BusinessTransactionIdFilter> businessTransactionIdFilterRegistration(BusinessTransactionIdFilter businessTransactionIdFilter) {
        return FilterRegistrationBeanUtil.createFilterRegistrationBean(businessTransactionIdFilter, this.filterOrder);
    }
}

