/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.config.filter;

import org.hawaiiframework.logging.config.filter.FilterRegistrationBeanUtil;
import org.hawaiiframework.logging.util.ClientIpResolver;
import org.hawaiiframework.logging.web.filter.ClientIpLogFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="hawaii.logging.filters.client-ip-log", name={"enabled"}, matchIfMissing=false)
public class ClientIpLogFilterConfiguration {
    public static final String CONFIG_PREFIX = "hawaii.logging.filters.client-ip-log";
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientIpLogFilterConfiguration.class);
    @Value(value="${hawaii.logging.filters.client-ip-log.http-header:X-Hawaii-Frontend-IP-Address}")
    private String headerName;
    @Value(value="${hawaii.logging.filters.client-ip-log.order:-800}")
    private int filterOrder;

    @Bean
    @ConditionalOnProperty(prefix="hawaii.logging.filters.client-ip-log", name={"enabled"}, matchIfMissing=true)
    public ClientIpLogFilter clientIpLogFilter() {
        LOGGER.trace("Configuration: header '{}', order '{}'.", (Object)this.headerName, (Object)this.filterOrder);
        return new ClientIpLogFilter(this.createClientIpResolver());
    }

    @Bean
    @ConditionalOnProperty(prefix="hawaii.logging.filters.client-ip-log", name={"enabled"}, matchIfMissing=true)
    public FilterRegistrationBean<ClientIpLogFilter> kibanaLogFilterRegistration(ClientIpLogFilter clientIpLogFilter) {
        return FilterRegistrationBeanUtil.createFilterRegistrationBean(clientIpLogFilter, this.filterOrder);
    }

    private ClientIpResolver createClientIpResolver() {
        return new ClientIpResolver(this.headerName);
    }
}

