/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.config.filter;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;

public final class FilterRegistrationBeanUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterRegistrationBeanUtil.class);
    private static final EnumSet<DispatcherType> ALL_DISPATCHER_TYPES = EnumSet.allOf(DispatcherType.class);

    private FilterRegistrationBeanUtil() {
    }

    public static <T extends Filter> FilterRegistrationBean<T> createFilterRegistrationBean(T filter, int filterOrder) {
        return FilterRegistrationBeanUtil.createFilterRegistrationBean(filter, filterOrder, ALL_DISPATCHER_TYPES);
    }

    public static <T extends Filter> FilterRegistrationBean<T> createFilterRegistrationBean(T filter, int filterOrder, EnumSet<DispatcherType> dispatcherTypes) {
        LOGGER.trace("Setting filter order for '{}' to '{}'.", filter, (Object)filterOrder);
        FilterRegistrationBean result = new FilterRegistrationBean(filter, new ServletRegistrationBean[0]);
        result.setOrder(filterOrder);
        result.setDispatcherTypes(dispatcherTypes);
        return result;
    }
}

