/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.config.filter;

import org.hawaiiframework.logging.config.filter.FilterRegistrationBeanUtil;
import org.hawaiiframework.logging.web.filter.KibanaLogCleanupFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="hawaii.logging.filters.kibana-log-cleanup", name={"enabled"}, matchIfMissing=true)
public class KibanaLogCleanupFilterConfiguration {
    public static final String CONFIG_PREFIX = "hawaii.logging.filters.kibana-log-cleanup";
    private static final Logger LOGGER = LoggerFactory.getLogger(KibanaLogCleanupFilterConfiguration.class);
    @Value(value="${hawaii.logging.filters.kibana-log-cleanup.order:-20000}")
    private int filterOrder;

    @Bean
    @ConditionalOnProperty(prefix="hawaii.logging.filters.kibana-log-cleanup", name={"enabled"}, matchIfMissing=true)
    public KibanaLogCleanupFilter kibanaLogCleanupFilter() {
        LOGGER.trace("Configuration: order '{}'.", (Object)this.filterOrder);
        return new KibanaLogCleanupFilter();
    }

    @Bean
    @ConditionalOnProperty(prefix="hawaii.logging.filters.kibana-log-cleanup", name={"enabled"}, matchIfMissing=true)
    public FilterRegistrationBean<KibanaLogCleanupFilter> kibanaLogCleanupFilterRegistration(KibanaLogCleanupFilter kibanaLogCleanupFilter) {
        return FilterRegistrationBeanUtil.createFilterRegistrationBean(kibanaLogCleanupFilter, this.filterOrder);
    }
}

