/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.config.filter;

import org.hawaiiframework.logging.config.FilterVoter;
import org.hawaiiframework.logging.config.filter.FilterRegistrationBeanUtil;
import org.hawaiiframework.logging.http.HawaiiRequestResponseLogger;
import org.hawaiiframework.logging.web.filter.RequestResponseLogFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="hawaii.logging.filters.request-response", name={"enabled"}, matchIfMissing=true)
public class RequestResponseLogFilterConfiguration {
    public static final String CONFIG_PREFIX = "hawaii.logging.filters.request-response";
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestResponseLogFilterConfiguration.class);
    @Value(value="${hawaii.logging.filters.request-response.order:-950}")
    private int filterOrder;

    @Bean
    @ConditionalOnProperty(prefix="hawaii.logging.filters.request-response", name={"enabled"}, matchIfMissing=true)
    public RequestResponseLogFilter requestResponseLogFilter(FilterVoter filterVoter, HawaiiRequestResponseLogger hawaiiLogger) {
        LOGGER.trace("Configuration: order '{}'.", (Object)this.filterOrder);
        return new RequestResponseLogFilter(hawaiiLogger, filterVoter);
    }

    @Bean
    @ConditionalOnProperty(prefix="hawaii.logging.filters.request-response", name={"enabled"}, matchIfMissing=true)
    public FilterRegistrationBean<RequestResponseLogFilter> requestResponseLogFilterRegistration(RequestResponseLogFilter requestResponseLogFilter) {
        return FilterRegistrationBeanUtil.createFilterRegistrationBean(requestResponseLogFilter, this.filterOrder);
    }
}

