/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.config.filter;

import org.hawaiiframework.logging.config.FilterVoter;
import org.hawaiiframework.logging.config.filter.FilterRegistrationBeanUtil;
import org.hawaiiframework.logging.web.filter.SoftwareVersionLogFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.info.BuildProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={BuildProperties.class})
@ConditionalOnProperty(prefix="hawaii.logging.filters.software-version", name={"enabled"}, matchIfMissing=true)
public class SoftwareVersionLogFilterConfiguration {
    public static final String CONFIG_PREFIX = "hawaii.logging.filters.software-version";
    private static final Logger LOGGER = LoggerFactory.getLogger(SoftwareVersionLogFilterConfiguration.class);
    @Value(value="${hawaii.logging.filters.software-version.order:-1200}")
    private int filterOrder;

    @Bean
    @ConditionalOnProperty(prefix="hawaii.logging.filters.software-version", name={"enabled"}, matchIfMissing=true)
    public SoftwareVersionLogFilter softwareVersionLogFilter(BuildProperties buildProperties, FilterVoter filterVoter) {
        LOGGER.trace("Configuration: order '{}'.", (Object)this.filterOrder);
        return new SoftwareVersionLogFilter(buildProperties, filterVoter);
    }

    @Bean
    @ConditionalOnProperty(prefix="hawaii.logging.filters.software-version", name={"enabled"}, matchIfMissing=true)
    public FilterRegistrationBean<SoftwareVersionLogFilter> softwareVersionLogFilterRegistration(SoftwareVersionLogFilter softwareVersionLogFilter) {
        return FilterRegistrationBeanUtil.createFilterRegistrationBean(softwareVersionLogFilter, this.filterOrder);
    }
}

