/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.config.filter;

import org.hawaiiframework.logging.config.filter.FilterRegistrationBeanUtil;
import org.hawaiiframework.logging.web.filter.TransactionIdFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="hawaii.logging.filters.transaction-id", name={"enabled"}, matchIfMissing=false)
public class TransactionIdFilterConfiguration {
    public static final String CONFIG_PREFIX = "hawaii.logging.filters.transaction-id";
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionIdFilterConfiguration.class);
    @Value(value="${hawaii.logging.filters.transaction-id.http-header:X-Hawaii-Tx-Id}")
    private String headerName;
    @Value(value="${hawaii.logging.filters.transaction-id.order:-500}")
    private int filterOrder;

    @Bean
    @ConditionalOnProperty(prefix="hawaii.logging.filters.transaction-id", name={"enabled"}, matchIfMissing=true)
    public TransactionIdFilter transactionIdFilter() {
        LOGGER.trace("Configuration: header '{}', order '{}'.", (Object)this.headerName, (Object)this.filterOrder);
        return new TransactionIdFilter(this.headerName);
    }

    @Bean
    @ConditionalOnProperty(prefix="hawaii.logging.filters.transaction-id", name={"enabled"}, matchIfMissing=true)
    public FilterRegistrationBean<TransactionIdFilter> transactionIdFilterRegistration(TransactionIdFilter transactionIdFilter) {
        return FilterRegistrationBeanUtil.createFilterRegistrationBean(transactionIdFilter, this.filterOrder);
    }
}

