/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.config.filter;

import jakarta.servlet.DispatcherType;
import java.util.EnumSet;
import org.hawaiiframework.logging.config.filter.FilterRegistrationBeanUtil;
import org.hawaiiframework.logging.web.filter.UserDetailsFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.core.userdetails.UserDetails;

@Configuration
@ConditionalOnClass(value={UserDetails.class})
@ConditionalOnProperty(prefix="hawaii.logging.filters.user-details", name={"enabled"}, matchIfMissing=true)
public class UserDetailsFilterConfiguration {
    public static final String CONFIG_PREFIX = "hawaii.logging.filters.user-details";
    private static final Logger LOGGER = LoggerFactory.getLogger(UserDetailsFilterConfiguration.class);
    @Value(value="${hawaii.logging.filters.user-details.order:200}")
    private int filterOrder;

    @Bean
    @ConditionalOnProperty(prefix="hawaii.logging.filters.user-details", name={"enabled"}, matchIfMissing=true)
    public UserDetailsFilter userDetailsFilter() {
        LOGGER.trace("Configuration: order '{}'.", (Object)this.filterOrder);
        return new UserDetailsFilter();
    }

    @Bean
    @ConditionalOnProperty(prefix="hawaii.logging.filters.user-details", name={"enabled"}, matchIfMissing=true)
    public FilterRegistrationBean<UserDetailsFilter> userDetailsFilterRegistration(UserDetailsFilter userDetailsFilter) {
        return FilterRegistrationBeanUtil.createFilterRegistrationBean(userDetailsFilter, this.filterOrder, EnumSet.of(DispatcherType.REQUEST));
    }
}

