/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.http;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.hawaiiframework.logging.config.MediaTypeVoter;
import org.hawaiiframework.logging.http.HawaiiRequestResponseLogger;
import org.hawaiiframework.logging.model.KibanaLogCallResultTypes;
import org.hawaiiframework.logging.model.KibanaLogField;
import org.hawaiiframework.logging.model.KibanaLogFieldNames;
import org.hawaiiframework.logging.model.KibanaLogFields;
import org.hawaiiframework.logging.model.KibanaLogTypeNames;
import org.hawaiiframework.logging.util.HttpRequestResponseBodyLogUtil;
import org.hawaiiframework.logging.util.HttpRequestResponseDebugLogUtil;
import org.hawaiiframework.logging.util.HttpRequestResponseHeadersLogUtil;
import org.hawaiiframework.logging.web.util.ContentCachingWrappedResponse;
import org.hawaiiframework.logging.web.util.ResettableHttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpResponse;

public class DefaultHawaiiRequestResponseLogger
implements HawaiiRequestResponseLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultHawaiiRequestResponseLogger.class);
    private final HttpRequestResponseHeadersLogUtil headersLogUtil;
    private final HttpRequestResponseBodyLogUtil bodyLogUtil;
    private final HttpRequestResponseDebugLogUtil debugLogUtil;
    private final MediaTypeVoter mediaTypeVoter;
    private final MediaTypeVoter bodyExcludedMediaTypeVoter;

    public DefaultHawaiiRequestResponseLogger(HttpRequestResponseHeadersLogUtil headersLogUtil, HttpRequestResponseBodyLogUtil bodyLogUtil, HttpRequestResponseDebugLogUtil debugLogUtil, MediaTypeVoter mediaTypeVoter, MediaTypeVoter bodyExcludedMediaTypeVoter) {
        this.bodyLogUtil = bodyLogUtil;
        this.headersLogUtil = headersLogUtil;
        this.debugLogUtil = debugLogUtil;
        this.mediaTypeVoter = mediaTypeVoter;
        this.bodyExcludedMediaTypeVoter = bodyExcludedMediaTypeVoter;
    }

    @Override
    public void logRequest(ResettableHttpServletRequest wrappedRequest) throws IOException {
        String method = wrappedRequest.getMethod();
        String requestUri = wrappedRequest.getRequestURI();
        int contentLength = wrappedRequest.getContentLength();
        String contentType = DefaultHawaiiRequestResponseLogger.getContentType((ServletRequest)wrappedRequest);
        boolean contentTypeCanBeLogged = this.contentTypeCanBeLogged(contentType);
        String requestHeaders = "";
        String requestBody = "";
        try {
            requestHeaders = this.headersLogUtil.getTxRequestHeaders((HttpServletRequest)wrappedRequest);
            KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.LOG_TYPE, KibanaLogTypeNames.REQUEST_BODY);
            KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.TX_REQUEST_METHOD, method);
            KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.TX_REQUEST_URI, requestUri);
            KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.TX_REQUEST_SIZE, contentLength);
            KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.TX_REQUEST_HEADERS, requestHeaders);
            if (contentTypeCanBeLogged) {
                requestBody = this.bodyLogUtil.getTxRequestBody((HttpServletRequest)wrappedRequest);
            }
            DefaultHawaiiRequestResponseLogger.addBodyTag(contentTypeCanBeLogged, KibanaLogFieldNames.TX_REQUEST_BODY, requestBody);
        }
        catch (Throwable throwable) {
            try {
                LOGGER.error("Error getting payload for request.", throwable);
                throw throwable;
            }
            catch (Throwable throwable2) {
                LOGGER.info("Invoked '{} {}' with content type '{}' and size of '{}' bytes.", new Object[]{method, requestUri, contentType, contentLength});
                if (contentTypeCanBeLogged && LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Request is:\n{}", (Object)this.debugLogUtil.getTxRequestDebugOutput((HttpServletRequest)wrappedRequest, requestHeaders, requestBody));
                }
                KibanaLogFields.clear(KibanaLogFieldNames.LOG_TYPE, KibanaLogFieldNames.TX_REQUEST_METHOD, KibanaLogFieldNames.TX_REQUEST_SIZE, KibanaLogFieldNames.TX_REQUEST_HEADERS, KibanaLogFieldNames.TX_REQUEST_BODY);
                wrappedRequest.reset();
                throw throwable2;
            }
        }
        LOGGER.info("Invoked '{} {}' with content type '{}' and size of '{}' bytes.", new Object[]{method, requestUri, contentType, contentLength});
        if (contentTypeCanBeLogged && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Request is:\n{}", (Object)this.debugLogUtil.getTxRequestDebugOutput((HttpServletRequest)wrappedRequest, requestHeaders, requestBody));
        }
        KibanaLogFields.clear(KibanaLogFieldNames.LOG_TYPE, KibanaLogFieldNames.TX_REQUEST_METHOD, KibanaLogFieldNames.TX_REQUEST_SIZE, KibanaLogFieldNames.TX_REQUEST_HEADERS, KibanaLogFieldNames.TX_REQUEST_BODY);
        wrappedRequest.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logRequest(HttpRequest request, byte[] body) {
        try {
            KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.LOG_TYPE, KibanaLogTypeNames.CALL_REQUEST_BODY);
            HttpMethod method = request.getMethod();
            KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.CALL_REQUEST_METHOD, method.name());
            String requestUri = request.getURI().toString();
            KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.CALL_REQUEST_URI, requestUri);
            int contentLength = body.length;
            KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.CALL_REQUEST_SIZE, contentLength);
            String requestHeaders = this.headersLogUtil.getCallRequestHeaders(request);
            KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.CALL_REQUEST_HEADERS, requestHeaders);
            MediaType contentType = DefaultHawaiiRequestResponseLogger.getContentType(request);
            boolean contentTypeCanBeLogged = this.contentTypeCanBeLogged(contentType);
            String requestBody = this.bodyLogUtil.getCallRequestBody(body);
            DefaultHawaiiRequestResponseLogger.addBodyTag(contentTypeCanBeLogged, KibanaLogFieldNames.CALL_REQUEST_BODY, requestBody);
            LOGGER.info("Calling '{} {}' with content type '{}' and size of '{}' bytes.", new Object[]{method, requestUri, contentType, contentLength});
            if (contentTypeCanBeLogged && LOGGER.isDebugEnabled()) {
                LOGGER.debug("Call is:\n{}", (Object)this.debugLogUtil.getCallRequestDebugOutput(method, requestUri, requestHeaders, requestBody));
            }
        }
        catch (Throwable throwable) {
            KibanaLogFields.clear(KibanaLogFieldNames.LOG_TYPE, KibanaLogFieldNames.CALL_REQUEST_METHOD, KibanaLogFieldNames.CALL_REQUEST_URI, KibanaLogFieldNames.CALL_REQUEST_SIZE, KibanaLogFieldNames.CALL_REQUEST_HEADERS, KibanaLogFieldNames.CALL_REQUEST_BODY);
            throw throwable;
        }
        KibanaLogFields.clear(KibanaLogFieldNames.LOG_TYPE, KibanaLogFieldNames.CALL_REQUEST_METHOD, KibanaLogFieldNames.CALL_REQUEST_URI, KibanaLogFieldNames.CALL_REQUEST_SIZE, KibanaLogFieldNames.CALL_REQUEST_HEADERS, KibanaLogFieldNames.CALL_REQUEST_BODY);
    }

    private boolean contentTypeCanBeLogged(MediaType contentType) {
        return this.mediaTypeVoter.mediaTypeMatches(contentType) && !this.bodyExcludedMediaTypeVoter.mediaTypeMatches(contentType);
    }

    private boolean contentTypeCanBeLogged(String contentType) {
        return this.mediaTypeVoter.mediaTypeMatches(contentType) && !this.bodyExcludedMediaTypeVoter.mediaTypeMatches(contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logResponse(HttpServletRequest servletRequest, ContentCachingWrappedResponse wrappedResponse) {
        try {
            KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.LOG_TYPE, KibanaLogTypeNames.RESPONSE_BODY);
            HttpStatus httpStatus = HttpStatus.valueOf((int)wrappedResponse.getStatus());
            KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.HTTP_STATUS, httpStatus.value());
            if (KibanaLogFields.get(KibanaLogFieldNames.TX_STATUS) == null) {
                KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.TX_STATUS, httpStatus);
            }
            int contentLength = wrappedResponse.getContentSize();
            KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.TX_RESPONSE_SIZE, contentLength);
            String responseHeaders = this.headersLogUtil.getTxResponseHeaders((HttpServletResponse)wrappedResponse);
            KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.TX_RESPONSE_HEADERS, responseHeaders);
            String contentType = DefaultHawaiiRequestResponseLogger.getContentType((ServletResponse)wrappedResponse);
            boolean contentTypeCanBeLogged = this.contentTypeCanBeLogged(contentType);
            String responseBody = this.bodyLogUtil.getTxResponseBody(wrappedResponse);
            DefaultHawaiiRequestResponseLogger.addBodyTag(contentTypeCanBeLogged, KibanaLogFieldNames.TX_RESPONSE_BODY, responseBody);
            String requestUri = servletRequest.getRequestURI();
            LOGGER.info("Response '{}' is '{}' with content type '{}' and size of '{}' bytes.", new Object[]{requestUri, httpStatus, contentType, contentLength});
            if (contentTypeCanBeLogged && LOGGER.isDebugEnabled()) {
                LOGGER.debug("Response is:\n{}", (Object)this.debugLogUtil.getTxResponseDebugOutput(servletRequest.getProtocol(), httpStatus, responseHeaders, responseBody));
            }
        }
        catch (Throwable throwable) {
            KibanaLogFields.clear(KibanaLogFieldNames.LOG_TYPE, KibanaLogFieldNames.TX_RESPONSE_SIZE, KibanaLogFieldNames.TX_RESPONSE_HEADERS, KibanaLogFieldNames.CALL_RESPONSE_BODY);
            throw throwable;
        }
        KibanaLogFields.clear(KibanaLogFieldNames.LOG_TYPE, KibanaLogFieldNames.TX_RESPONSE_SIZE, KibanaLogFieldNames.TX_RESPONSE_HEADERS, KibanaLogFieldNames.CALL_RESPONSE_BODY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logResponse(ClientHttpResponse response) throws IOException {
        try {
            KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.LOG_TYPE, KibanaLogTypeNames.CALL_RESPONSE_BODY);
            MediaType contentType = DefaultHawaiiRequestResponseLogger.getContentType(response);
            boolean contentTypeCanBeLogged = this.contentTypeCanBeLogged(contentType);
            String responseBody = this.bodyLogUtil.getCallResponseBody(response);
            DefaultHawaiiRequestResponseLogger.addBodyTag(contentTypeCanBeLogged, KibanaLogFieldNames.CALL_RESPONSE_BODY, responseBody);
            int contentLength = responseBody.length();
            KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.CALL_RESPONSE_SIZE, contentLength);
            String responseHeaders = this.headersLogUtil.getCallResponseHeaders(response);
            KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.CALL_RESPONSE_HEADERS, responseHeaders);
            HttpStatusCode httpStatus = response.getStatusCode();
            if (httpStatus.is2xxSuccessful() || httpStatus.is3xxRedirection()) {
                KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.CALL_STATUS, KibanaLogCallResultTypes.SUCCESS);
            } else {
                KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.CALL_STATUS, KibanaLogCallResultTypes.FAILURE);
            }
            LOGGER.info("Got response '{}' with content type '{}' and size of '{}' bytes.", new Object[]{httpStatus, contentType, contentLength});
            if (contentTypeCanBeLogged && LOGGER.isDebugEnabled()) {
                LOGGER.debug("Got response '{}':\n{}", (Object)httpStatus, (Object)this.debugLogUtil.getCallResponseDebugOutput(responseHeaders, responseBody));
            }
        }
        catch (Throwable throwable) {
            KibanaLogFields.clear(KibanaLogFieldNames.LOG_TYPE, KibanaLogFieldNames.CALL_RESPONSE_SIZE, KibanaLogFieldNames.CALL_RESPONSE_HEADERS, KibanaLogFieldNames.CALL_RESPONSE_BODY);
            throw throwable;
        }
        KibanaLogFields.clear(KibanaLogFieldNames.LOG_TYPE, KibanaLogFieldNames.CALL_RESPONSE_SIZE, KibanaLogFieldNames.CALL_RESPONSE_HEADERS, KibanaLogFieldNames.CALL_RESPONSE_BODY);
    }

    private static void addBodyTag(boolean contentTypeCanBeLogged, KibanaLogFieldNames tag, String responseBody) {
        if (contentTypeCanBeLogged) {
            KibanaLogFields.tag((KibanaLogField)tag, responseBody);
        } else {
            KibanaLogFields.tag((KibanaLogField)tag, "invalid mime type for logging");
        }
    }

    private static MediaType getContentType(HttpRequest request) {
        return DefaultHawaiiRequestResponseLogger.getContentType(request.getHeaders());
    }

    private static MediaType getContentType(ClientHttpResponse response) {
        return DefaultHawaiiRequestResponseLogger.getContentType(response.getHeaders());
    }

    private static MediaType getContentType(HttpHeaders httpHeaders) {
        return httpHeaders.getContentType();
    }

    private static String getContentType(ServletRequest wrappedRequest) {
        return wrappedRequest.getContentType();
    }

    private static String getContentType(ServletResponse response) {
        return response.getContentType();
    }
}

