/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.model;

import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hawaiiframework.logging.model.AutoCloseableKibanaLogField;
import org.hawaiiframework.logging.model.AutoCloseableKibanaLogFieldImpl;
import org.hawaiiframework.logging.model.KibanaLogContext;
import org.hawaiiframework.logging.model.KibanaLogField;
import org.hawaiiframework.logging.model.KibanaLogFieldNames;
import org.slf4j.MDC;

public final class KibanaLogFields {
    private KibanaLogFields() {
    }

    public static KibanaLogField tag(KibanaLogField field, Enum<?> value) {
        return KibanaLogFields.tag(field, value.toString());
    }

    public static KibanaLogField tag(KibanaLogField field, int value) {
        return KibanaLogFields.tag(field, Integer.toString(value));
    }

    public static KibanaLogField tag(KibanaLogField field, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            KibanaLogFields.clear(field);
            return field;
        }
        MDC.put((String)field.getLogName(), (String)value);
        return field;
    }

    public static KibanaLogField tag(KibanaLogField field, Collection<String> values) {
        if (values == null || values.isEmpty()) {
            return KibanaLogFields.tag(field, (String)null);
        }
        String value = values.stream().map(item -> String.format("'%s'", item)).collect(Collectors.joining(", ", "[", "]"));
        return KibanaLogFields.tag(field, value);
    }

    public static AutoCloseableKibanaLogField tagCloseable(KibanaLogField field, Enum<?> value) {
        return KibanaLogFields.tagCloseable(field, value.toString());
    }

    public static AutoCloseableKibanaLogField tagCloseable(KibanaLogField field, int value) {
        return KibanaLogFields.tagCloseable(field, Integer.toString(value));
    }

    public static AutoCloseableKibanaLogField tagCloseable(KibanaLogField field, String value) {
        return new AutoCloseableKibanaLogFieldImpl(KibanaLogFields.tag(field, value));
    }

    public static AutoCloseableKibanaLogField tagCloseable(KibanaLogField field, Collection<String> values) {
        return new AutoCloseableKibanaLogFieldImpl(KibanaLogFields.tag(field, values));
    }

    public static String get(KibanaLogField field) {
        return KibanaLogFields.getOrDefault(field, null);
    }

    public static String getOrDefault(KibanaLogField field, String defaultValue) {
        return (String)StringUtils.defaultIfEmpty((CharSequence)MDC.get((String)field.getLogName()), (CharSequence)defaultValue);
    }

    public static void clear(KibanaLogField field) {
        MDC.remove((String)field.getLogName());
    }

    public static void clear(KibanaLogField ... fields) {
        for (KibanaLogField field : fields) {
            MDC.remove((String)field.getLogName());
        }
    }

    public static void clear() {
        MDC.clear();
    }

    public static String getValuesAsLogString() {
        StringBuilder result = new StringBuilder();
        MDC.getCopyOfContextMap().forEach((key, value) -> {
            if (!key.equals(KibanaLogFieldNames.LOG_TYPE.getLogName())) {
                result.append(' ').append((String)key).append("=\"").append((String)value).append('\"');
            }
        });
        return result.toString();
    }

    public static void populateFromContext(KibanaLogContext logContext) {
        if (logContext != null) {
            MDC.setContextMap(logContext.getContextMap());
        }
    }

    public static KibanaLogContext getContext() {
        return new KibanaLogContext();
    }
}

