/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.oidc;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.text.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.hawaiiframework.logging.model.KibanaLogField;
import org.hawaiiframework.logging.model.KibanaLogFields;
import org.hawaiiframework.logging.oidc.OidcKibanaLogFieldNames;
import org.hawaiiframework.logging.web.filter.AbstractGenericFilterBean;
import org.hawaiiframework.logging.web.filter.UserDetailsFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcLogFilter
extends AbstractGenericFilterBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserDetailsFilter.class);
    private static final String BEARER = "Bearer ";

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String header = request.getHeader("Authorization");
        if (StringUtils.isNotBlank((CharSequence)header) && header.startsWith(BEARER)) {
            String token = header.substring(BEARER.length());
            try {
                JWT jwt = JWTParser.parse((String)token);
                JWTClaimsSet claimsSet = jwt.getJWTClaimsSet();
                KibanaLogFields.tag((KibanaLogField)OidcKibanaLogFieldNames.SUBJECT, claimsSet.getSubject());
                KibanaLogFields.tag((KibanaLogField)OidcKibanaLogFieldNames.AUDIENCE, claimsSet.getAudience());
                KibanaLogFields.tag((KibanaLogField)OidcKibanaLogFieldNames.AUTHORIZED_PARTY, claimsSet.getStringClaim("azp"));
                KibanaLogFields.tag((KibanaLogField)OidcKibanaLogFieldNames.USER_ID, claimsSet.getStringClaim("user_id"));
            }
            catch (ParseException exception) {
                LOGGER.warn("Caught exception parsing JWT.", (Throwable)exception);
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

