/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.opentelemetry;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Objects;
import org.hawaiiframework.logging.web.filter.AbstractGenericFilterBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTelemetryTraceIdResponseFilter
extends AbstractGenericFilterBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenTelemetryTraceIdResponseFilter.class);
    private final String headerName;

    public OpenTelemetryTraceIdResponseFilter(String headerName) {
        this.headerName = Objects.toString(headerName, "traceid");
        LOGGER.info("Configured to use '{}'.", (Object)this.headerName);
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Span activeSpan = Span.current();
        if (activeSpan != null) {
            this.addHeader(response, activeSpan.getSpanContext());
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void addHeader(HttpServletResponse response, SpanContext context) {
        this.addHeader(response, context.getTraceId());
    }

    private void addHeader(HttpServletResponse response, String value) {
        if (!response.containsHeader(this.headerName)) {
            response.setHeader(this.headerName, value);
        }
    }
}

