/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.sql;

import org.hawaiiframework.logging.sql.SqlLoggingState;

public final class SqlStatementLogging {
    private static final ThreadLocal<SqlLoggingState> THREAD_LOCAL_STORE = new ThreadLocal();

    private SqlStatementLogging() {
    }

    public static SqlLoggingState suppress() {
        return SqlStatementLogging.suppress(true);
    }

    public static SqlLoggingState suppress(boolean suppressed) {
        SqlLoggingState suppressor = new SqlLoggingState();
        if (suppressed) {
            THREAD_LOCAL_STORE.set(suppressor);
        }
        return suppressor;
    }

    public static void enable() {
        THREAD_LOCAL_STORE.remove();
    }

    public static boolean isSuppressed() {
        return THREAD_LOCAL_STORE.get() != null;
    }

    public static void clear() {
        THREAD_LOCAL_STORE.remove();
    }
}

