/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.util;

import jakarta.servlet.http.HttpServletRequest;
import org.hawaiiframework.logging.util.IndentUtil;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

public class HttpRequestResponseDebugLogUtil {
    private static final String NEW_LINE = System.lineSeparator();

    private static String createRequestLine(String method, String request, String protocol) {
        return String.format("%s %s %s", method, request, protocol);
    }

    private static String createLogString(String requestLine, String headers, String body) {
        StringBuilder builder = new StringBuilder();
        if (requestLine != null) {
            builder.append(requestLine).append(NEW_LINE);
        }
        if (headers != null && !headers.isEmpty()) {
            builder.append(headers);
        }
        if (body != null && !body.isEmpty()) {
            builder.append(NEW_LINE).append(body);
        }
        String value = builder.toString();
        return IndentUtil.indent(value);
    }

    public String getTxRequestDebugOutput(HttpServletRequest servletRequest, String headers, String body) {
        String requestLine = HttpRequestResponseDebugLogUtil.createRequestLine(servletRequest.getMethod(), servletRequest.getRequestURI(), servletRequest.getProtocol());
        return HttpRequestResponseDebugLogUtil.createLogString(requestLine, headers, body);
    }

    public String getTxResponseDebugOutput(String protocol, HttpStatus httpStatus, String headers, String body) {
        String statusLine = String.format("%s %s", protocol, httpStatus);
        return HttpRequestResponseDebugLogUtil.createLogString(statusLine, headers, body);
    }

    public String getCallRequestDebugOutput(HttpMethod method, String requestUri, String headers, String body) {
        return this.getCallRequestDebugOutput(method.name(), requestUri, headers, body);
    }

    public String getCallRequestDebugOutput(String method, String requestUri, String headers, String body) {
        String requestLine = HttpRequestResponseDebugLogUtil.createRequestLine(method, requestUri, "");
        return HttpRequestResponseDebugLogUtil.createLogString(requestLine, headers, body);
    }

    public String getCallResponseDebugOutput(String headers, String body) {
        return HttpRequestResponseDebugLogUtil.createLogString(null, headers, body);
    }
}

