/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.util;

import java.util.Objects;

public class MaskedPasswordBuilder {
    private static final String MASKED_PASSWORD = "***";
    private final String pattern;
    private final int patternLength;
    private final String stringToMask;
    private int currentIndex;
    private int savedCurrentIndex;
    private int lastAddedIndex;
    private final StringBuilder result = new StringBuilder();

    public MaskedPasswordBuilder(String stringToMask, String pattern) {
        this.stringToMask = Objects.requireNonNull(stringToMask);
        this.pattern = pattern;
        this.patternLength = pattern.length();
    }

    public boolean hasNext() {
        return this.currentIndex < this.stringToMask.length();
    }

    public void next() {
        ++this.currentIndex;
    }

    public boolean currentCharIsOneOf(Character ... choices) {
        for (Character choice : choices) {
            if (!this.currentCharIs(choice)) continue;
            return true;
        }
        return false;
    }

    public boolean currentCharIs(Character character) {
        return character.equals(this.getCurrentChar());
    }

    public boolean currentCharIsWhitespace() {
        return Character.isWhitespace(this.getCurrentChar().charValue());
    }

    private Character getCurrentChar() {
        return Character.valueOf(this.stringToMask.charAt(this.currentIndex));
    }

    public void mark() {
        this.savedCurrentIndex = this.currentIndex;
    }

    public void reset() {
        this.currentIndex = this.savedCurrentIndex;
    }

    public void maskPasswordAt(Integer index) {
        this.result.append(this.stringToMask, this.lastAddedIndex, (int)index).append(MASKED_PASSWORD);
        this.lastAddedIndex = this.currentIndex;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public boolean findNextPassword() {
        int index = this.stringToMask.indexOf(this.pattern, this.currentIndex);
        if (index <= -1) {
            return false;
        }
        this.currentIndex = index + this.patternLength;
        return true;
    }

    public String build() {
        this.result.append(this.stringToMask.substring(this.lastAddedIndex));
        return this.result.toString();
    }
}

