/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.util;

import jakarta.servlet.http.HttpServletRequest;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UuidResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(UuidResolver.class);

    public UUID resolve(HttpServletRequest request, String headerName) {
        UUID uuid = null;
        String txIdHeader = request.getHeader(headerName);
        if (StringUtils.isNotBlank((CharSequence)txIdHeader)) {
            LOGGER.trace("Found header '{}' with value '{}' in request.", (Object)headerName, (Object)txIdHeader);
            try {
                uuid = UUID.fromString(txIdHeader);
            }
            catch (IllegalArgumentException exception) {
                LOGGER.error("Could not create UUID from header.", (Throwable)exception);
            }
        }
        if (uuid == null) {
            uuid = UUID.randomUUID();
            LOGGER.trace("Generated new UUID '{}'.", (Object)uuid);
        }
        return uuid;
    }
}

