/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.util;

import org.hawaiiframework.logging.util.MaskedPasswordBuilder;
import org.hawaiiframework.logging.util.PasswordMasker;

public class XmlAttributePasswordMasker
implements PasswordMasker {
    private static final Character LT = Character.valueOf('<');
    private static final Character GT = Character.valueOf('>');

    @Override
    public boolean matches(MaskedPasswordBuilder builder) {
        if (builder.currentCharIs(GT)) {
            builder.mark();
            int indexOfStartPassword = builder.getCurrentIndex();
            if (XmlAttributePasswordMasker.readUntilEndOfXmlValue(builder)) {
                builder.maskPasswordAt(indexOfStartPassword + 1);
                XmlAttributePasswordMasker.readUntilEndOfXmlTag(builder);
                return true;
            }
            builder.reset();
        }
        return false;
    }

    private static boolean readUntilEndOfXmlValue(MaskedPasswordBuilder builder) {
        while (builder.hasNext()) {
            if (builder.currentCharIs(LT)) {
                return true;
            }
            builder.next();
        }
        return false;
    }

    private static void readUntilEndOfXmlTag(MaskedPasswordBuilder builder) {
        while (builder.hasNext() && !builder.currentCharIs(GT)) {
            builder.next();
        }
    }
}

