/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.web.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.hawaiiframework.logging.model.KibanaLogField;
import org.hawaiiframework.logging.model.KibanaLogFieldNames;
import org.hawaiiframework.logging.model.KibanaLogFields;
import org.hawaiiframework.logging.web.filter.AbstractGenericFilterBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerNameHttpHeaderFilter
extends AbstractGenericFilterBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContainerNameHttpHeaderFilter.class);
    private final String headerName;
    private final String hostname;

    public ContainerNameHttpHeaderFilter(String headerName, String hostName) {
        this.headerName = headerName;
        this.hostname = hostName;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.HOST_NAME, this.hostname);
        LOGGER.debug("Set '{}' with value '{}'.", (Object)this.headerName, (Object)this.hostname);
        if (!response.containsHeader(this.headerName)) {
            response.addHeader(this.headerName, this.hostname);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

