/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.web.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.hawaiiframework.logging.config.FilterVoter;
import org.hawaiiframework.logging.http.HawaiiRequestResponseLogger;
import org.hawaiiframework.logging.model.MockMvcFilter;
import org.hawaiiframework.logging.web.filter.AbstractGenericFilterBean;
import org.hawaiiframework.logging.web.util.ContentCachingWrappedResponse;
import org.hawaiiframework.logging.web.util.ResettableHttpServletRequest;
import org.hawaiiframework.logging.web.util.WrappedHttpRequestResponse;

public class RequestResponseLogFilter
extends AbstractGenericFilterBean
implements MockMvcFilter {
    private final HawaiiRequestResponseLogger hawaiiLogger;
    private final FilterVoter filterVoter;

    public RequestResponseLogFilter(HawaiiRequestResponseLogger hawaiiLogger, FilterVoter filterVoter) {
        this.hawaiiLogger = hawaiiLogger;
        this.filterVoter = filterVoter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        if (this.filterVoter.enabled(httpServletRequest)) {
            WrappedHttpRequestResponse wrapped = this.getWrapped(httpServletRequest, httpServletResponse);
            this.hawaiiLogger.logRequest(wrapped.request());
            try {
                filterChain.doFilter((ServletRequest)wrapped.request(), (ServletResponse)wrapped.response());
            }
            finally {
                this.logResponse(wrapped);
            }
        }
        try {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        finally {
            this.logResponse(this.getWrapped(httpServletRequest));
        }
    }

    private void logResponse(WrappedHttpRequestResponse wrapped) throws IOException {
        ContentCachingWrappedResponse response;
        ResettableHttpServletRequest request;
        if (wrapped != null && !this.isAsyncStarted((HttpServletRequest)(request = wrapped.request())) && this.filterVoter.enabled((HttpServletRequest)request) && (response = wrapped.response()) != null) {
            this.hawaiiLogger.logResponse((HttpServletRequest)request, response);
        }
    }

    protected boolean shouldNotFilterAsyncDispatch() {
        return false;
    }
}

