/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.web.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.UUID;
import org.hawaiiframework.logging.model.KibanaLogField;
import org.hawaiiframework.logging.model.KibanaLogFieldNames;
import org.hawaiiframework.logging.model.KibanaLogFields;
import org.hawaiiframework.logging.model.MockMvcFilter;
import org.hawaiiframework.logging.model.TransactionId;
import org.hawaiiframework.logging.util.UuidResolver;
import org.hawaiiframework.logging.web.filter.AbstractGenericFilterBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionIdFilter
extends AbstractGenericFilterBean
implements MockMvcFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionIdFilter.class);
    private final String headerName;
    private final UuidResolver uuidResolver = new UuidResolver();

    public TransactionIdFilter(String headerName) {
        this.headerName = headerName;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        UUID uuid = this.uuidResolver.resolve(request, this.headerName);
        TransactionId.set(uuid);
        KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.TX_ID, TransactionId.get());
        LOGGER.debug("Set '{}' with value '{};.", (Object)KibanaLogFieldNames.TX_ID.getLogName(), (Object)uuid);
        if (!response.containsHeader(this.headerName)) {
            response.addHeader(this.headerName, TransactionId.get());
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

