/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.web.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import org.hawaiiframework.logging.model.KibanaLogField;
import org.hawaiiframework.logging.model.KibanaLogFieldNames;
import org.hawaiiframework.logging.model.KibanaLogFields;
import org.hawaiiframework.logging.web.filter.AbstractGenericFilterBean;
import org.hawaiiframework.logging.web.util.ResettableHttpServletRequest;
import org.hawaiiframework.logging.web.util.TransactionTypeSupplier;
import org.hawaiiframework.logging.web.util.WrappedHttpRequestResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionTypeFilter
extends AbstractGenericFilterBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionTypeFilter.class);
    private final List<TransactionTypeSupplier> suppliers;

    public TransactionTypeFilter(List<TransactionTypeSupplier> suppliers) {
        this.suppliers = suppliers;
    }

    protected void doFilterInternal(HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain filterChain) throws ServletException, IOException {
        try {
            WrappedHttpRequestResponse wrapped = this.getWrapped(httpRequest, httpResponse);
            String type = this.getTransactionType(wrapped.request());
            KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.TX_TYPE, type);
            LOGGER.trace("Set '{}' with value '{}'.", (Object)KibanaLogFieldNames.TX_TYPE.getLogName(), (Object)type);
            filterChain.doFilter((ServletRequest)wrapped.request(), (ServletResponse)wrapped.response());
        }
        catch (IOException ignored) {
            LOGGER.warn("Could not determine the transaction type.", (Throwable)ignored);
        }
    }

    private String getTransactionType(ResettableHttpServletRequest wrappedRequest) throws IOException {
        for (TransactionTypeSupplier supplier : this.suppliers) {
            String type = supplier.getTransactionType(wrappedRequest);
            if (type == null) continue;
            return type;
        }
        return null;
    }
}

