/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.web.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.hawaiiframework.logging.model.KibanaLogField;
import org.hawaiiframework.logging.model.KibanaLogFieldNames;
import org.hawaiiframework.logging.model.KibanaLogFields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.web.filter.OncePerRequestFilter;

public class UserDetailsFilter
extends OncePerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserDetailsFilter.class);

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null && !(auth instanceof AnonymousAuthenticationToken)) {
            Object principal = auth.getPrincipal();
            LOGGER.debug("Request called by '{}'.", principal);
            if (principal instanceof UserDetails) {
                UserDetails userDetails = (UserDetails)principal;
                String username = userDetails.getUsername();
                KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.USER_NAME, username);
                LOGGER.debug("User has user name '{}'.", (Object)username);
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

