/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.web.sse;

import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import org.hawaiiframework.logging.model.KibanaLogContext;
import org.hawaiiframework.logging.model.KibanaLogFields;
import org.hawaiiframework.logging.web.sse.LoggingSseHttpOutputMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyEmitter;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

public class LoggingSseEmitter
extends SseEmitter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingSseEmitter.class);
    private final KibanaLogContext context;
    private final List<HttpMessageConverter<?>> converters;

    public LoggingSseEmitter(List<HttpMessageConverter<?>> converters, KibanaLogContext context) {
        this.converters = converters;
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(SseEmitter.SseEventBuilder builder) throws IOException {
        LoggingSseHttpOutputMessage output = new LoggingSseHttpOutputMessage();
        block3: for (ResponseBodyEmitter.DataWithMediaType dataWithMediaType : builder.build()) {
            Object data = dataWithMediaType.getData();
            MediaType mediaType = dataWithMediaType.getMediaType();
            for (HttpMessageConverter<?> converter : this.converters) {
                if (!converter.canWrite(data.getClass(), mediaType)) continue;
                converter.write(data, mediaType, (HttpOutputMessage)output);
                continue block3;
            }
        }
        super.send(builder);
        KibanaLogContext currentCtx = KibanaLogFields.getContext();
        try {
            KibanaLogFields.populateFromContext(this.context);
            LOGGER.info(output.getContents());
        }
        finally {
            KibanaLogFields.clear();
            KibanaLogFields.populateFromContext(currentCtx);
        }
    }

    public synchronized void onError(Consumer<Throwable> callback) {
        super.onError(throwable -> {
            KibanaLogContext currentCtx = KibanaLogFields.getContext();
            try {
                KibanaLogFields.populateFromContext(this.context);
                callback.accept((Throwable)throwable);
                LOGGER.trace("End of stream.");
            }
            finally {
                KibanaLogFields.clear();
                KibanaLogFields.populateFromContext(currentCtx);
            }
        });
    }
}

