/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.web.util;

import graphql.ErrorClassification;
import org.hawaiiframework.logging.web.util.GraphQlHttpStatusSupplier;
import org.springframework.core.annotation.Order;
import org.springframework.graphql.execution.ErrorType;
import org.springframework.http.HttpStatus;

@Order(value=0)
public class GraphQlErrorTypeHttpStatusSupplier
implements GraphQlHttpStatusSupplier {
    @Override
    public HttpStatus getStatus(ErrorClassification error) {
        if (error instanceof ErrorType) {
            ErrorType errorType = (ErrorType)error;
            return switch (errorType) {
                default -> throw new IncompatibleClassChangeError();
                case ErrorType.NOT_FOUND -> HttpStatus.NOT_FOUND;
                case ErrorType.INTERNAL_ERROR -> HttpStatus.INTERNAL_SERVER_ERROR;
                case ErrorType.BAD_REQUEST -> HttpStatus.BAD_REQUEST;
                case ErrorType.FORBIDDEN -> HttpStatus.FORBIDDEN;
                case ErrorType.UNAUTHORIZED -> HttpStatus.UNAUTHORIZED;
            };
        }
        return null;
    }
}

