/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.web.util;

import graphql.ErrorClassification;
import graphql.GraphQLError;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import org.hawaiiframework.logging.model.KibanaLogField;
import org.hawaiiframework.logging.model.KibanaLogFieldNames;
import org.hawaiiframework.logging.model.KibanaLogFields;
import org.hawaiiframework.logging.web.util.GraphQlHttpStatusSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.graphql.execution.DataFetcherExceptionResolver;
import org.springframework.http.HttpStatus;
import reactor.core.publisher.Mono;

public class KibanaDataFetcherExceptionResolver
implements DataFetcherExceptionResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(KibanaDataFetcherExceptionResolver.class);
    private final DataFetcherExceptionResolver delegate;
    private final List<GraphQlHttpStatusSupplier> suppliers;

    public KibanaDataFetcherExceptionResolver(DataFetcherExceptionResolver delegate, List<GraphQlHttpStatusSupplier> suppliers) {
        this.delegate = delegate;
        this.suppliers = suppliers;
    }

    private HttpStatus convertToErrorCode(ErrorClassification errorClassification) {
        for (GraphQlHttpStatusSupplier supplier : this.suppliers) {
            HttpStatus status = supplier.getStatus(errorClassification);
            if (status == null) continue;
            return status;
        }
        LOGGER.info("Could not identify the HTTP status based on the graphQl error `{}`.", (Object)errorClassification);
        return HttpStatus.INTERNAL_SERVER_ERROR;
    }

    public Mono<List<GraphQLError>> resolveException(Throwable exception, DataFetchingEnvironment environment) {
        Mono monoErrors = this.delegate.resolveException(exception, environment);
        List errors = (List)monoErrors.block();
        if (errors != null && !errors.isEmpty()) {
            ErrorClassification errorType = ((GraphQLError)errors.get(0)).getErrorType();
            HttpStatus errorCode = this.convertToErrorCode(errorType);
            KibanaLogFields.tag((KibanaLogField)KibanaLogFieldNames.TX_STATUS, errorCode);
        }
        return monoErrors;
    }
}

