/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.web.util;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpUpgradeHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.hawaiiframework.logging.web.util.ResettableServletInputStream;

public class ResettableHttpServletRequest
extends HttpServletRequestWrapper {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private ResettableServletInputStream servletStream;

    public ResettableHttpServletRequest(HttpServletRequest request, HttpServletResponse response) {
        super(request);
        this.request = request;
        this.response = response;
    }

    public void reset() throws IOException {
        if (this.servletStream != null) {
            this.servletStream.reset();
        }
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.servletStream == null) {
            this.servletStream = new ResettableServletInputStream(this.copyRawData());
        }
        return this.servletStream;
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), this.request.getCharacterEncoding()));
    }

    private byte[] copyRawData() throws IOException {
        return IOUtils.toByteArray((Reader)this.request.getReader(), (String)this.request.getCharacterEncoding());
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> httpUpgradeHandlerClass) throws IOException, ServletException {
        this.response.setStatus(101);
        return (T)this.request.upgrade(httpUpgradeHandlerClass);
    }
}

