/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.web.util;

import jakarta.servlet.http.HttpServletRequest;
import org.hawaiiframework.logging.web.util.ResettableHttpServletRequest;
import org.hawaiiframework.logging.web.util.TransactionTypeSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerMapping;

@Order(value=1000)
public class SpringMvcTransactionTypeSupplier
implements TransactionTypeSupplier {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringMvcTransactionTypeSupplier.class);
    private final ApplicationContext applicationContext;

    public SpringMvcTransactionTypeSupplier(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public String getTransactionType(ResettableHttpServletRequest request) {
        for (HandlerMapping handlerMapping : this.applicationContext.getBeansOfType(HandlerMapping.class).values()) {
            String transactionType;
            HandlerExecutionChain handlerExecutionChain = null;
            try {
                handlerExecutionChain = handlerMapping.getHandler((HttpServletRequest)request);
            }
            catch (Exception exception) {
                LOGGER.warn("Exception when fetching the handler");
            }
            if ((transactionType = SpringMvcTransactionTypeSupplier.getTransactionType(handlerExecutionChain)) == null) continue;
            return transactionType;
        }
        LOGGER.debug("No handler found.");
        return null;
    }

    private static String getTransactionType(HandlerExecutionChain handlerExecutionChain) {
        Object tempHandler;
        if (handlerExecutionChain != null && (tempHandler = handlerExecutionChain.getHandler()) instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)tempHandler;
            return SpringMvcTransactionTypeSupplier.getTransactionType(handlerMethod);
        }
        return null;
    }

    private static String getTransactionType(HandlerMethod handler) {
        String nameMethod = handler.getMethod().getName();
        String nameController = handler.getBeanType().getSimpleName();
        return nameController + "." + nameMethod;
    }
}

