/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging;

import org.hawaiiframework.exception.HawaiiException;
import org.hawaiiframework.logging.KibanaLogTransaction;
import org.hawaiiframework.logging.model.AutoCloseableKibanaLogField;
import org.hawaiiframework.logging.model.KibanaLogField;
import org.hawaiiframework.logging.model.KibanaLogFieldNames;
import org.hawaiiframework.logging.model.KibanaLogFields;
import org.hawaiiframework.logging.model.KibanaLogTypeNames;
import org.hawaiiframework.util.Invocable;
import org.hawaiiframework.util.Returnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KibanaTxWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(KibanaTxWrapper.class);

    private KibanaTxWrapper() {
    }

    /*
     * Exception decompiling
     */
    public static <T> T kibanaTx(String system, String txName, Returnable<T> returnable) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void kibanaTx(String system, String txName, Invocable invocable) {
        long startTime = System.nanoTime();
        try (KibanaLogTransaction kibanaLogTransaction = new KibanaLogTransaction(KibanaTxWrapper.getTxType(system, txName));){
            try {
                KibanaTxWrapper.logStart();
                invocable.invoke();
            }
            catch (RuntimeException rethrown) {
                KibanaTxWrapper.logError(rethrown);
                throw rethrown;
            }
            catch (Throwable throwable) {
                KibanaTxWrapper.logError(throwable);
                throw new HawaiiException(throwable);
            }
            finally {
                KibanaTxWrapper.logEnd(startTime);
            }
        }
    }

    private static void logStart() {
        try (AutoCloseableKibanaLogField startTag = KibanaLogFields.tagCloseable((KibanaLogField)KibanaLogFieldNames.LOG_TYPE, KibanaLogTypeNames.CALL_START);){
            LOGGER.info("Started '{}'.", (Object)KibanaLogFields.get(KibanaLogFieldNames.TX_TYPE));
        }
    }

    private static void logEnd(long startTime) {
        String duration = String.format("%.2f", (double)(System.nanoTime() - startTime) / 1000000.0);
        try (AutoCloseableKibanaLogField endTag = KibanaLogFields.tagCloseable((KibanaLogField)KibanaLogFieldNames.LOG_TYPE, KibanaLogTypeNames.END);
             AutoCloseableKibanaLogField durationTag = KibanaLogFields.tagCloseable((KibanaLogField)KibanaLogFieldNames.TX_DURATION, duration);){
            LOGGER.info("Duration '{}' ms.", (Object)duration);
        }
    }

    private static String getTxType(String system, String txName) {
        return String.format("%s.%s", system, txName);
    }

    private static void logError(Throwable throwable) {
        LOGGER.error("Got exception '{}' with message '{}'.", new Object[]{throwable.getClass().getSimpleName(), throwable.getMessage(), throwable});
    }
}

