/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.config;

import org.hawaiiframework.logging.config.CxfLoggingConfiguration;
import org.hawaiiframework.logging.config.FilterVoter;
import org.hawaiiframework.logging.config.HawaiiLoggingConfigurationProperties;
import org.hawaiiframework.logging.config.HawaiiLoggingFilterConfiguration;
import org.hawaiiframework.logging.config.MediaTypeVoter;
import org.hawaiiframework.logging.config.RequestVoter;
import org.hawaiiframework.logging.config.ScheduledConfiguration;
import org.hawaiiframework.logging.config.StatementLoggerQueryExecutionListenerConfiguration;
import org.hawaiiframework.logging.http.DefaultHawaiiRequestResponseLogger;
import org.hawaiiframework.logging.http.HawaiiRequestResponseLogger;
import org.hawaiiframework.logging.http.client.LoggingClientHttpRequestInterceptor;
import org.hawaiiframework.logging.util.HttpRequestResponseBodyLogUtil;
import org.hawaiiframework.logging.util.HttpRequestResponseDebugLogUtil;
import org.hawaiiframework.logging.util.HttpRequestResponseHeadersLogUtil;
import org.hawaiiframework.logging.util.PasswordMaskerUtil;
import org.hawaiiframework.sql.DataSourceProxyConfiguration;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={CxfLoggingConfiguration.class, DataSourceProxyConfiguration.class, HawaiiLoggingFilterConfiguration.class, ScheduledConfiguration.class, StatementLoggerQueryExecutionListenerConfiguration.class})
public class HawaiiLoggingConfiguration {
    @Bean
    @RefreshScope
    public HawaiiLoggingConfigurationProperties hawaiiLoggingConfigurationProperties() {
        return new HawaiiLoggingConfigurationProperties();
    }

    @Bean
    @RefreshScope
    public PasswordMaskerUtil passwordMaskerUtil(HawaiiLoggingConfigurationProperties properties) {
        return new PasswordMaskerUtil(properties.getFieldsToMask());
    }

    @Bean
    @RefreshScope
    public HttpRequestResponseHeadersLogUtil httpRequestResponseHeadersLogUtil(PasswordMaskerUtil passwordMasker) {
        return new HttpRequestResponseHeadersLogUtil(passwordMasker);
    }

    @Bean
    @RefreshScope
    public HttpRequestResponseBodyLogUtil httpRequestResponseLogBodyUtil(PasswordMaskerUtil passwordMasker) {
        return new HttpRequestResponseBodyLogUtil(passwordMasker);
    }

    @Bean
    public HttpRequestResponseDebugLogUtil debugLogUtil() {
        return new HttpRequestResponseDebugLogUtil();
    }

    @Bean
    @RefreshScope
    public LoggingClientHttpRequestInterceptor loggingClientHttpRequestInterceptor(HawaiiRequestResponseLogger hawaiiRequestResponseLogger) {
        return new LoggingClientHttpRequestInterceptor(hawaiiRequestResponseLogger);
    }

    @Bean
    @ConditionalOnMissingBean(value={HawaiiRequestResponseLogger.class})
    @RefreshScope
    public HawaiiRequestResponseLogger hawaiiRequestResponseLogger(HttpRequestResponseHeadersLogUtil headersLogUtil, HttpRequestResponseBodyLogUtil bodyLogUtil, HttpRequestResponseDebugLogUtil debugLogUtil, MediaTypeVoter mediaTypeVoter, @Qualifier(value="bodyExcludedMediaTypeVoter") MediaTypeVoter bodyExcludedMediaTypeVoter) {
        return new DefaultHawaiiRequestResponseLogger(headersLogUtil, bodyLogUtil, debugLogUtil, mediaTypeVoter, bodyExcludedMediaTypeVoter);
    }

    @Bean
    @RefreshScope
    public MediaTypeVoter mediaTypeVoter(HawaiiLoggingConfigurationProperties hawaiiLoggingConfigurationProperties) {
        return new MediaTypeVoter(hawaiiLoggingConfigurationProperties.getAllowedContentTypes(), true);
    }

    @Bean
    @RefreshScope
    public MediaTypeVoter bodyExcludedMediaTypeVoter(HawaiiLoggingConfigurationProperties hawaiiLoggingConfigurationProperties) {
        return new MediaTypeVoter(hawaiiLoggingConfigurationProperties.getBodyExcludedContentTypes(), false);
    }

    @Bean
    @RefreshScope
    public RequestVoter requestVoter(HawaiiLoggingConfigurationProperties hawaiiLoggingConfigurationProperties) {
        return new RequestVoter(hawaiiLoggingConfigurationProperties);
    }

    @Bean
    @RefreshScope
    public FilterVoter filterVoter(MediaTypeVoter mediaTypeVoter, RequestVoter requestVoter) {
        return new FilterVoter(mediaTypeVoter, requestVoter);
    }
}

