/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.config;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;

public class MediaTypeVoter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaTypeVoter.class);
    private final List<MediaType> contentTypes;
    private final boolean matchIfEmpty;

    public MediaTypeVoter(List<MediaType> contentTypes, boolean matchIfEmpty) {
        this.contentTypes = contentTypes;
        this.matchIfEmpty = matchIfEmpty;
        LOGGER.debug("Configured content types: '{}'.", contentTypes);
    }

    public boolean mediaTypeMatches(String contentType) {
        return this.mediaTypeMatches(MediaTypeVoter.parseMediaType(contentType));
    }

    public boolean mediaTypeMatches(MediaType mediaType) {
        boolean matches = false;
        if (mediaType == null || this.contentTypes == null || this.contentTypes.isEmpty()) {
            matches = this.matchIfEmpty;
        } else {
            for (MediaType allowedType : this.contentTypes) {
                boolean includes = allowedType.includes(mediaType);
                LOGGER.trace("Type '{}' contains '{}': '{}'.", new Object[]{allowedType, mediaType, includes});
                if (!includes) continue;
                matches = true;
            }
            LOGGER.debug("Media type '{}' does not match, since it is not configured.", (Object)mediaType);
        }
        return matches;
    }

    private static MediaType parseMediaType(String contentType) {
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            try {
                return MediaType.parseMediaType((String)contentType);
            }
            catch (InvalidMediaTypeException exception) {
                LOGGER.info("Got error parsing content type '{}'.", (Object)contentType, (Object)exception);
            }
        }
        return null;
    }
}

