/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.config;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.hawaiiframework.logging.config.HawaiiLoggingConfigurationProperties;
import org.hawaiiframework.logging.model.PathDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestVoter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestVoter.class);
    private final List<PathDefinition> exclusions;

    public RequestVoter(HawaiiLoggingConfigurationProperties properties) {
        this.exclusions = properties.getExcludePaths();
        LOGGER.info("Excluded paths '{}'.", this.exclusions);
    }

    public boolean allowed(HttpServletRequest request) {
        if (!this.isEmpty()) {
            String method = request.getMethod();
            String path = request.getServletPath();
            for (PathDefinition exclusion : this.exclusions) {
                boolean excluded = exclusion.matches(method, path);
                LOGGER.trace("Request'{} {}' matches '{}': '{}'.", new Object[]{method, path, exclusion, excluded});
                if (!excluded) continue;
                LOGGER.trace("Request'{} {}' excluded because of match with '{}'.", new Object[]{method, path, exclusion});
                return false;
            }
        }
        return true;
    }

    private boolean isEmpty() {
        return this.exclusions == null || this.exclusions.isEmpty();
    }
}

