/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.config.filter;

import org.hawaiiframework.logging.config.filter.FilterRegistrationBeanUtil;
import org.hawaiiframework.logging.web.filter.ContainerNameHttpHeaderFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="hawaii.logging.filters.container-name", name={"enabled"}, matchIfMissing=true)
public class ContainerNameHttpHeaderFilterConfiguration {
    public static final String CONFIG_PREFIX = "hawaii.logging.filters.container-name";
    private static final Logger LOGGER = LoggerFactory.getLogger(ContainerNameHttpHeaderFilterConfiguration.class);
    @Value(value="${hawaii.logging.filters.container-name.http-header:X-Hawaii-Hostname}")
    private String headerName;
    @Value(value="${hawaii.logging.filters.container-name.order:-1100}")
    private int filterOrder;
    @Value(value="${hawaii.logging.filters.container-name.hostname:localhost}")
    private String hostname;

    @Bean
    @ConditionalOnProperty(prefix="hawaii.logging.filters.container-name", name={"enabled"}, matchIfMissing=true)
    public ContainerNameHttpHeaderFilter containerNameHttpHeaderFilter() {
        LOGGER.trace("Configuration: header '{}', order '{}', hostname '{}'.", new Object[]{this.headerName, this.filterOrder, this.hostname});
        return new ContainerNameHttpHeaderFilter(this.headerName, this.hostname);
    }

    @Bean
    @ConditionalOnProperty(prefix="hawaii.logging.filters.container-name", name={"enabled"}, matchIfMissing=true)
    public FilterRegistrationBean<ContainerNameHttpHeaderFilter> containerNameHttpHeaderFilterRegistration(ContainerNameHttpHeaderFilter filter) {
        return FilterRegistrationBeanUtil.createFilterRegistrationBean(filter, this.filterOrder);
    }
}

