/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.config.filter;

import io.micrometer.tracing.Tracer;
import org.hawaiiframework.logging.config.filter.FilterRegistrationBeanUtil;
import org.hawaiiframework.logging.micrometer.MicrometerTraceIdResponseFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={Tracer.class})
@ConditionalOnProperty(prefix="hawaii.logging.open-telemetry-tracing-response", name={"enabled"}, matchIfMissing=true)
public class MicrometerTracingResponseFilterConfiguration {
    public static final String CONFIG_PREFIX = "hawaii.logging.filters.micrometer-tracing-response";
    private static final Logger LOGGER = LoggerFactory.getLogger(MicrometerTracingResponseFilterConfiguration.class);
    @Value(value="${hawaii.logging.filters.micrometer-tracing-response.http-header:traceid}")
    private String headerName;
    @Value(value="${hawaii.logging.filters.micrometer-tracing-response.order:-1000}")
    private int filterOrder;

    @Bean
    @ConditionalOnProperty(prefix="hawaii.logging.filters.micrometer-tracing-response", name={"enabled"}, matchIfMissing=true)
    public MicrometerTraceIdResponseFilter micrometerTraceIdResponseFilter(Tracer tracer) {
        LOGGER.trace("Configuration: header '{}', order '{}'.", (Object)this.headerName, (Object)this.filterOrder);
        return new MicrometerTraceIdResponseFilter(this.headerName, tracer);
    }

    @Bean
    @ConditionalOnProperty(prefix="hawaii.logging.filters.micrometer-tracing-response", name={"enabled"}, matchIfMissing=true)
    public FilterRegistrationBean<MicrometerTraceIdResponseFilter> micrometerTraceIdResponseFilterRegistration(MicrometerTraceIdResponseFilter micrometerTraceIdResponseFilter) {
        return FilterRegistrationBeanUtil.createFilterRegistrationBean(micrometerTraceIdResponseFilter, this.filterOrder);
    }
}

