/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.config.filter;

import com.nimbusds.jwt.PlainJWT;
import org.hawaiiframework.logging.config.filter.FilterRegistrationBeanUtil;
import org.hawaiiframework.logging.oidc.OidcLogFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={PlainJWT.class})
@ConditionalOnProperty(prefix="hawaii.logging.filters.oidc", name={"enabled"}, matchIfMissing=true)
public class OidcLogFilterConfiguration {
    public static final String CONFIG_PREFIX = "hawaii.logging.filters.oidc";
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcLogFilterConfiguration.class);
    @Value(value="${hawaii.logging.filters.oidc.order:-900}")
    private int filterOrder;

    @Bean
    @ConditionalOnProperty(prefix="hawaii.logging.filters.oidc", name={"enabled"}, matchIfMissing=true)
    public OidcLogFilter oidcLogFilter() {
        LOGGER.trace("Configuration: order '{}'.", (Object)this.filterOrder);
        return new OidcLogFilter();
    }

    @Bean
    @ConditionalOnProperty(prefix="hawaii.logging.filters.oidc", name={"enabled"}, matchIfMissing=true)
    public FilterRegistrationBean<OidcLogFilter> oidcLogFilterRegistration(OidcLogFilter oidcLogFilter) {
        return FilterRegistrationBeanUtil.createFilterRegistrationBean(oidcLogFilter, this.filterOrder);
    }
}

