/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.config.filter;

import io.opentelemetry.api.trace.Tracer;
import org.hawaiiframework.logging.config.filter.FilterRegistrationBeanUtil;
import org.hawaiiframework.logging.opentelemetry.OpenTelemetryTraceIdResponseFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={Tracer.class})
@ConditionalOnProperty(prefix="hawaii.logging.open-telemetry-tracing-response", name={"enabled"}, matchIfMissing=false)
public class OpenTelemetryTraceIdResponseFilterConfiguration {
    public static final String CONFIG_PREFIX = "hawaii.logging.open-telemetry-tracing-response";
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenTelemetryTraceIdResponseFilterConfiguration.class);
    @Value(value="${hawaii.logging.open-telemetry-tracing-response.http-header:-1000}")
    private String headerName;
    @Value(value="${hawaii.logging.open-telemetry-tracing-response.order:traceid}")
    private int filterOrder;

    @Bean
    @ConditionalOnProperty(prefix="hawaii.logging.open-telemetry-tracing-response", name={"enabled"}, matchIfMissing=true)
    public OpenTelemetryTraceIdResponseFilter openTelemetryTraceIdResponseFilter() {
        LOGGER.trace("Configuration: header '{}', order '{}'.", (Object)this.headerName, (Object)this.filterOrder);
        return new OpenTelemetryTraceIdResponseFilter(this.headerName);
    }

    @Bean
    @ConditionalOnProperty(prefix="hawaii.logging.open-telemetry-tracing-response", name={"enabled"}, matchIfMissing=true)
    public FilterRegistrationBean<OpenTelemetryTraceIdResponseFilter> openTelemetryTraceIdResponseFilterFilterRegistrationBean(OpenTelemetryTraceIdResponseFilter openTelemetryResponseFilter) {
        return FilterRegistrationBeanUtil.createFilterRegistrationBean(openTelemetryResponseFilter, this.filterOrder);
    }
}

