/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.config.filter;

import org.hawaiiframework.logging.config.FilterVoter;
import org.hawaiiframework.logging.config.filter.FilterRegistrationBeanUtil;
import org.hawaiiframework.logging.web.filter.RequestDurationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="hawaii.logging.filters.request-duration", name={"enabled"}, matchIfMissing=true)
public class RequestDurationFilterConfiguration {
    public static final String CONFIG_PREFIX = "hawaii.logging.filters.request-duration";
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestDurationFilterConfiguration.class);
    @Value(value="${hawaii.logging.filters.request-duration.order:-17500}")
    private int filterOrder;

    @Bean
    @ConditionalOnProperty(prefix="hawaii.logging.filters.request-duration", name={"enabled"}, matchIfMissing=true)
    public RequestDurationFilter requestDurationFilter(FilterVoter filterVoter) {
        LOGGER.trace("Configuration: order '{}'.", (Object)this.filterOrder);
        return new RequestDurationFilter(filterVoter);
    }

    @Bean
    @ConditionalOnProperty(prefix="hawaii.logging.filters.request-duration", name={"enabled"}, matchIfMissing=true)
    public FilterRegistrationBean<RequestDurationFilter> requestDurationFilterRegistration(RequestDurationFilter requestDurationFilter) {
        return FilterRegistrationBeanUtil.createFilterRegistrationBean(requestDurationFilter, this.filterOrder);
    }
}

