/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.config.filter;

import org.hawaiiframework.logging.config.filter.FilterRegistrationBeanUtil;
import org.hawaiiframework.logging.web.filter.RequestIdFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="hawaii.logging.filters.request-id", name={"enabled"}, matchIfMissing=false)
public class RequestIdFilterConfiguration {
    public static final String CONFIG_PREFIX = "hawaii.logging.filters.request-id";
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestIdFilterConfiguration.class);
    @Value(value="${hawaii.logging.filters.request-id.http-header:X-Hawaii-Request-Id}")
    private String headerName;
    @Value(value="${hawaii.logging.filters.request-id.order:-400}")
    private int filterOrder;

    @Bean
    @ConditionalOnProperty(prefix="hawaii.logging.filters.request-id", name={"enabled"}, matchIfMissing=true)
    public RequestIdFilter requestIdFilter() {
        LOGGER.trace("Configuration: header '{}', order '{}'.", (Object)this.headerName, (Object)this.filterOrder);
        return new RequestIdFilter(this.headerName);
    }

    @Bean
    @ConditionalOnProperty(prefix="hawaii.logging.filters.request-id", name={"enabled"}, matchIfMissing=true)
    public FilterRegistrationBean<RequestIdFilter> requestIdFilterRegistration(RequestIdFilter requestIdFilter) {
        return FilterRegistrationBeanUtil.createFilterRegistrationBean(requestIdFilter, this.filterOrder);
    }
}

