/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.config.filter;

import java.util.List;
import org.hawaiiframework.logging.config.filter.FilterRegistrationBeanUtil;
import org.hawaiiframework.logging.web.filter.TransactionTypeFilter;
import org.hawaiiframework.logging.web.util.GraphQlTransactionTypeSupplier;
import org.hawaiiframework.logging.web.util.SpringMvcTransactionTypeSupplier;
import org.hawaiiframework.logging.web.util.TransactionTypeSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="hawaii.logging.filters.transaction-type", name={"enabled"}, matchIfMissing=true)
public class TransactionTypeFilterConfiguration {
    public static final String CONFIG_PREFIX = "hawaii.logging.filters.transaction-type";
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionTypeFilterConfiguration.class);
    @Value(value="${hawaii.logging.filters.transaction-type.order:-1000}")
    private int filterOrder;

    @Bean
    @ConditionalOnProperty(prefix="hawaii.logging.filters.transaction-type", name={"enabled"}, matchIfMissing=true)
    public TransactionTypeFilter transactionTypeFilter(List<TransactionTypeSupplier> transactionTypeSuppliers) {
        LOGGER.trace("Configuration: order '{}'.", (Object)this.filterOrder);
        return new TransactionTypeFilter(transactionTypeSuppliers);
    }

    @Bean
    @ConditionalOnProperty(prefix="hawaii.logging.filters.transaction-type", name={"enabled"}, matchIfMissing=true)
    public SpringMvcTransactionTypeSupplier springMvcTransactionTypeSupplier(ApplicationContext applicationContext) {
        return new SpringMvcTransactionTypeSupplier(applicationContext);
    }

    @Bean
    @ConditionalOnProperty(prefix="hawaii.logging.filters.transaction-type", name={"enabled"}, matchIfMissing=true)
    public GraphQlTransactionTypeSupplier graphQlTransactionTypeSupplier() {
        return new GraphQlTransactionTypeSupplier();
    }

    @Bean
    @ConditionalOnProperty(prefix="hawaii.logging.filters.transaction-type", name={"enabled"}, matchIfMissing=true)
    public FilterRegistrationBean<TransactionTypeFilter> transactionTypeFilterRegistration(TransactionTypeFilter transactionNameFilter) {
        return FilterRegistrationBeanUtil.createFilterRegistrationBean(transactionNameFilter, this.filterOrder);
    }
}

