/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.http.client;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.hawaiiframework.logging.model.KibanaLogFieldNames;
import org.hawaiiframework.logging.model.KibanaLogFields;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class BusinessTransactionIdSupplierHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    private final String headerName;

    public BusinessTransactionIdSupplierHttpRequestInterceptor() {
        this("X-Hawaii-Business-Tx-Id");
    }

    public BusinessTransactionIdSupplierHttpRequestInterceptor(String headerName) {
        this.headerName = headerName;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        String btxId = KibanaLogFields.get(KibanaLogFieldNames.BUSINESS_TX_ID);
        if (StringUtils.isNotBlank((CharSequence)btxId)) {
            request.getHeaders().add(this.headerName, btxId);
        }
        return execution.execute(request, body);
    }
}

