/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.logging.http.client;

import org.hawaiiframework.logging.http.client.HttpRequestLoggingState;

public final class HttpRequestLogging {
    private static final ThreadLocal<HttpRequestLoggingState> THREAD_LOCAL_STORE = new ThreadLocal();

    private HttpRequestLogging() {
    }

    public static HttpRequestLoggingState suppress() {
        return HttpRequestLogging.suppress(true);
    }

    public static HttpRequestLoggingState suppress(boolean suppressed) {
        HttpRequestLoggingState suppressor = new HttpRequestLoggingState();
        if (suppressed) {
            THREAD_LOCAL_STORE.set(suppressor);
        }
        return suppressor;
    }

    public static void enable() {
        THREAD_LOCAL_STORE.remove();
    }

    public static boolean isEnabled() {
        return !HttpRequestLogging.isSuppressed();
    }

    public static boolean isSuppressed() {
        return THREAD_LOCAL_STORE.get() != null;
    }

    public static void clear() {
        THREAD_LOCAL_STORE.remove();
    }
}

